# Gmail SMTP Setup Guide for Local Development

## Step 1: Enable Gmail SMTP
1. Go to your Gmail account settings
2. Click on "Security" tab
3. Enable "2-Step Verification" if not already enabled
4. Generate an "App Password":
   - Go to Security → 2-Step Verification → App Passwords
   - Select "Mail" and "Windows Computer" (or Custom)
   - Copy the generated 16-character password

## Step 2: Configure POS System Settings
Go to: **Settings → Email Settings** in your POS system

### Required Settings:
- **Enable Email**: ✅ Check this box
- **SMTP Host**: `smtp.gmail.com`
- **SMTP Port**: `587`
- **SMTP Username**: `your-gmail@gmail.com`
- **SMTP Password**: `your-16-character-app-password`
- **SMTP Encryption**: `TLS`
- **Sender Name**: `Your Store Name`
- **Test Email Address**: `your-test-email@gmail.com`

## Step 3: Test Configuration
1. Save the settings
2. Click "Test Email Configuration"
3. Check your test email inbox

## Step 4: Verify PHP Settings (if needed)
Check your `php.ini` file for these settings:
```ini
extension=openssl
extension=curl
```

## Common Issues:
- **"Less secure app access"**: Use App Password instead
- **Port blocked**: Try port 465 with SSL instead of 587 with TLS
- **Authentication failed**: Double-check App Password 